/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.bukkit.listeners;

import com.gufli.kingdomcraft.api.domain.User;
import com.gufli.kingdomcraft.bukkit.KingdomCraftBukkitPlugin;
import com.gufli.kingdomcraft.bukkit.util.LocationConverter;
import org.bukkit.Location;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerRespawnEvent;

public class RespawnListener
implements Listener {
    private final KingdomCraftBukkitPlugin plugin;

    public RespawnListener(KingdomCraftBukkitPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onRespawn(PlayerRespawnEvent event) {
        if (!this.plugin.getKdc().getConfig().respawnAtKingdom()) {
            return;
        }
        User user = this.plugin.getKdc().getOnlineUser(event.getPlayer().getUniqueId());
        if (user.getKingdom() == null || user.getKingdom().getSpawn() == null) {
            return;
        }
        Location loc = LocationConverter.convert(user.getKingdom().getSpawn());
        event.setRespawnLocation(loc);
    }
}

