/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.bukkit.listeners;

import com.gufli.kingdomcraft.api.domain.User;
import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.events.PlayerLoadedEvent;
import com.gufli.kingdomcraft.api.events.PluginReloadEvent;
import com.gufli.kingdomcraft.api.events.UserJoinKingdomEvent;
import com.gufli.kingdomcraft.api.events.UserLeaveKingdomEvent;
import com.gufli.kingdomcraft.api.events.UserRankChangeEvent;
import com.gufli.kingdomcraft.bukkit.KingdomCraftBukkitPlugin;
import com.gufli.kingdomcraft.bukkit.entity.BukkitPlayer;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.plugin.Plugin;

public class PermissionsListener
implements Listener {
    private static final String PERMISSIONS_KEY = "permission_attachement";
    private final KingdomCraftBukkitPlugin plugin;

    public PermissionsListener(KingdomCraftBukkitPlugin plugin) {
        this.plugin = plugin;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        plugin.getKdc().getEventManager().addListener((Class)PlayerLoadedEvent.class, this::onJoin);
        plugin.getKdc().getEventManager().addListener((Class)UserRankChangeEvent.class, this::onRankChange);
        plugin.getKdc().getEventManager().addListener((Class)UserLeaveKingdomEvent.class, this::onKingdomLeave);
        plugin.getKdc().getEventManager().addListener((Class)UserJoinKingdomEvent.class, this::onKingdomJoin);
        plugin.getKdc().getEventManager().addListener((Class)PluginReloadEvent.class, this::onReload);
        plugin.getKdc().getOnlinePlayers().forEach(this::update);
    }

    @EventHandler
    public void onTeleport(PlayerTeleportEvent e) {
        if (e.getFrom().getWorld() == e.getTo().getWorld()) {
            return;
        }
        this.update(this.plugin.getKdc().getPlayer(e.getPlayer().getUniqueId()));
    }

    public void onJoin(PlayerLoadedEvent e) {
        this.update(e.getPlayer());
    }

    public void onRankChange(UserRankChangeEvent e) {
        this.update(e.getUser());
    }

    public void onKingdomLeave(UserLeaveKingdomEvent e) {
        this.update(e.getUser());
    }

    public void onKingdomJoin(UserJoinKingdomEvent e) {
        this.update(e.getUser());
    }

    public void onReload(PluginReloadEvent e) {
        this.plugin.getKdc().getOnlinePlayers().forEach(this::update);
    }

    void clear(PlatformPlayer player) {
        if (!player.has(PERMISSIONS_KEY)) {
            return;
        }
        PermissionAttachment pa = player.get(PERMISSIONS_KEY, PermissionAttachment.class);
        Player p = ((BukkitPlayer)player).getPlayer();
        p.removeAttachment(pa);
    }

    private void update(User user) {
        PlatformPlayer player = this.plugin.getKdc().getPlayer(user);
        if (player != null) {
            this.update(player);
        }
    }

    void update(PlatformPlayer player) {
        this.clear(player);
        Map<String, Boolean> permissions = this.plugin.getKdc().getPermissionManager().getTotalPermissions(player);
        Player p = ((BukkitPlayer)player).getPlayer();
        PermissionAttachment pa = p.addAttachment((Plugin)this.plugin);
        if (pa == null) {
            this.plugin.log("Unable to set permissions for " + player.getName() + ".", Level.SEVERE);
            this.plugin.log("Plugin status: " + (this.plugin.isEnabled() ? "enabled" : "disabled"), Level.SEVERE);
            this.plugin.log("Player online: " + (p.isOnline() ? "yes" : "no"), Level.SEVERE);
            return;
        }
        for (String perm : permissions.keySet()) {
            pa.setPermission(perm, permissions.get(perm).booleanValue());
        }
        player.set(PERMISSIONS_KEY, pa);
    }
}

