/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.bukkit.listeners;

import com.gufli.kingdomcraft.api.domain.Kingdom;
import com.gufli.kingdomcraft.api.domain.User;
import com.gufli.kingdomcraft.api.events.UserJoinKingdomEvent;
import com.gufli.kingdomcraft.api.events.UserLeaveKingdomEvent;
import com.gufli.kingdomcraft.bukkit.KingdomCraftBukkitPlugin;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class KingdomJoinQuitListener {
    private final KingdomCraftBukkitPlugin plugin;

    public KingdomJoinQuitListener(KingdomCraftBukkitPlugin plugin) {
        this.plugin = plugin;
        plugin.getKdc().getEventManager().addListener((Class)UserJoinKingdomEvent.class, this::onKingdomJoin);
        plugin.getKdc().getEventManager().addListener((Class)UserLeaveKingdomEvent.class, this::onKingdomLeave);
    }

    public void onKingdomJoin(UserJoinKingdomEvent e) {
        if (this.plugin.getKdc().getConfig().getOnKingdomJoinCommands().isEmpty()) {
            return;
        }
        this.plugin.getScheduler().sync().execute(() -> this.execute(e.getUser(), e.getUser().getKingdom(), this.plugin.getKdc().getConfig().getOnKingdomJoinCommands()));
    }

    public void onKingdomLeave(UserLeaveKingdomEvent e) {
        if (this.plugin.getKdc().getConfig().getOnKingdomLeaveCommands().isEmpty()) {
            return;
        }
        this.plugin.getScheduler().sync().execute(() -> this.execute(e.getUser(), e.getKingdom(), this.plugin.getKdc().getConfig().getOnKingdomLeaveCommands()));
    }

    private void execute(User user, Kingdom kingdom, List<String> commands) {
        Player bplayer = Bukkit.getPlayer((UUID)user.getUniqueId());
        this.plugin.log("Executing kingdom join/leave commands: ");
        for (String cmd : commands) {
            cmd = cmd.replace("{username}", user.getName());
            cmd = cmd.replace("{kingdom_name}", kingdom.getName());
            cmd = cmd.replace("{kingdom}", this.plugin.colorify(kingdom.getDisplay()));
            cmd = cmd.replace("{kingdom_prefix}", this.plugin.colorify(kingdom.getPrefix()));
            cmd = cmd.replace("{kingdom_suffix}", this.plugin.colorify(kingdom.getSuffix()));
            cmd = this.plugin.getKdc().getPlaceholderManager().handle(user, cmd);
            if (cmd.toLowerCase().startsWith("console")) {
                cmd = cmd.substring(7).trim();
                this.plugin.log(cmd);
                this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getServer().getConsoleSender(), cmd);
                continue;
            }
            if (bplayer == null || !bplayer.isOnline()) continue;
            bplayer.chat("/" + cmd);
        }
    }
}

