/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.bukkit.listeners;

import com.gufli.kingdomcraft.api.domain.Kingdom;
import com.gufli.kingdomcraft.api.events.KingdomCreateEvent;
import com.gufli.kingdomcraft.api.events.KingdomDeleteEvent;
import com.gufli.kingdomcraft.bukkit.KingdomCraftBukkitPlugin;
import java.util.List;
import org.bukkit.command.CommandSender;

public class KingdomCreateDeleteListener {
    private final KingdomCraftBukkitPlugin plugin;

    public KingdomCreateDeleteListener(KingdomCraftBukkitPlugin plugin) {
        this.plugin = plugin;
        plugin.getKdc().getEventManager().addListener((Class)KingdomCreateEvent.class, this::onKingdomCreate);
        plugin.getKdc().getEventManager().addListener((Class)KingdomDeleteEvent.class, this::onKingdomDelete);
    }

    public void onKingdomCreate(KingdomCreateEvent e) {
        if (this.plugin.getKdc().getConfig().getOnKingdomCreateCommands().isEmpty()) {
            return;
        }
        this.plugin.getScheduler().sync().execute(() -> this.execute(e.getKingdom(), this.plugin.getKdc().getConfig().getOnKingdomCreateCommands()));
    }

    public void onKingdomDelete(KingdomDeleteEvent e) {
        if (this.plugin.getKdc().getConfig().getOnKingdomDeleteCommands().isEmpty()) {
            return;
        }
        this.plugin.getScheduler().sync().execute(() -> this.execute(e.getKingdom(), this.plugin.getKdc().getConfig().getOnKingdomDeleteCommands()));
    }

    private void execute(Kingdom kingdom, List<String> commands) {
        this.plugin.log("Executing kingdom create/delete commands: ");
        for (String cmd : commands) {
            cmd = cmd.replace("{kingdom}", kingdom.getDisplay());
            if ((cmd = cmd.replace("{kingdom_name}", kingdom.getName())).toLowerCase().startsWith("console")) {
                cmd = cmd.substring(7).trim();
            }
            this.plugin.log(cmd);
            this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getServer().getConsoleSender(), cmd);
        }
    }
}

