/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.bukkit.listeners;

import com.gufli.kingdomcraft.api.domain.User;
import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.events.PlayerLeaveEvent;
import com.gufli.kingdomcraft.api.events.PlayerLoadedEvent;
import com.gufli.kingdomcraft.bukkit.KingdomCraftBukkitPlugin;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class JoinQuitListener
implements Listener {
    private final KingdomCraftBukkitPlugin plugin;

    public JoinQuitListener(KingdomCraftBukkitPlugin plugin) {
        this.plugin = plugin;
        plugin.getKdc().getEventManager().addListener((Class)PlayerLoadedEvent.class, this::onJoin);
        plugin.getKdc().getEventManager().addListener((Class)PlayerLeaveEvent.class, this::onLeave);
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent e) {
        if (this.plugin.getKdc().getConfig().getOnJoinMessage() != null && !this.plugin.getKdc().getConfig().getOnJoinMessage().equals("")) {
            e.setJoinMessage(null);
        }
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent e) {
        if (this.plugin.getKdc().getConfig().getOnLeaveMessage() != null && !this.plugin.getKdc().getConfig().getOnLeaveMessage().equals("")) {
            e.setQuitMessage(null);
        }
    }

    public void onJoin(PlayerLoadedEvent e) {
        String msg = this.plugin.getKdc().getConfig().getOnJoinMessage();
        if (msg == null || msg.equals("")) {
            return;
        }
        this.send(e.getPlayer(), msg);
    }

    public void onLeave(PlayerLeaveEvent e) {
        String msg = this.plugin.getKdc().getConfig().getOnLeaveMessage();
        if (msg == null || msg.equals("")) {
            return;
        }
        this.send(e.getPlayer(), msg);
    }

    private void send(PlatformPlayer player, String msg) {
        if (msg == null || msg.equals("")) {
            return;
        }
        msg = this.plugin.getKdc().getPlaceholderManager().handle(player, msg);
        msg = this.plugin.getKdc().getMessages().colorify(msg);
        if (this.plugin.getKdc().getConfig().showJoinAndLeaveKingdomOnly()) {
            User user = player.getUser();
            if (user.getKingdom() == null) {
                return;
            }
            String finalMsg = msg;
            this.plugin.getKdc().getOnlinePlayers().stream().filter(p -> p.getUser().getKingdom() == user.getKingdom()).forEach(p -> p.sendMessage(finalMsg));
        } else {
            String finalMsg = msg;
            this.plugin.getKdc().getOnlinePlayers().forEach(p -> p.sendMessage(finalMsg));
        }
    }
}

