/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.bukkit.listeners;

import com.gufli.kingdomcraft.api.domain.Kingdom;
import com.gufli.kingdomcraft.api.domain.Relation;
import com.gufli.kingdomcraft.api.domain.RelationType;
import com.gufli.kingdomcraft.api.domain.User;
import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.entity.PlatformSender;
import com.gufli.kingdomcraft.api.events.FriendlyFireCancelEvent;
import com.gufli.kingdomcraft.bukkit.KingdomCraftBukkitPlugin;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerFishEvent;

public class FriendlyFireListener
implements Listener {
    private final KingdomCraftBukkitPlugin plugin;

    public FriendlyFireListener(KingdomCraftBukkitPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onPlayerDamage(EntityDamageByEntityEvent e) {
        this.handleEvent(e, e.getEntity(), e.getDamager());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onEntityCombustByEntity(EntityCombustByEntityEvent e) {
        this.handleEvent(e, e.getEntity(), e.getCombuster());
    }

    @EventHandler
    public void onPlayerFish(PlayerFishEvent e) {
        if (e.getState() == PlayerFishEvent.State.CAUGHT_ENTITY) {
            this.handleEvent(e, e.getCaught(), (Entity)e.getPlayer());
        }
    }

    private <T extends Cancellable> void handleEvent(T e, Entity entity, Entity damager) {
        PlatformPlayer d;
        if (this.plugin.getKdc().getConfig().isFriendlyFireEnabled()) {
            return;
        }
        if (!(entity instanceof Player)) {
            return;
        }
        PlatformPlayer p = this.plugin.getKdc().getPlayer(entity.getUniqueId());
        if (damager instanceof Player) {
            d = this.plugin.getKdc().getPlayer(damager.getUniqueId());
        } else if (damager instanceof Projectile && ((Projectile)damager).getShooter() instanceof Player) {
            d = this.plugin.getKdc().getPlayer(((Player)((Projectile)damager).getShooter()).getUniqueId());
        } else {
            return;
        }
        if (p == null || d == null) {
            return;
        }
        if (p == d) {
            return;
        }
        if (d.isAdmin() && d.hasPermission("kingdom.admin.friendlyfire")) {
            return;
        }
        User u1 = this.plugin.getKdc().getUser(p);
        User u2 = this.plugin.getKdc().getUser(d);
        if (u1 == null || u2 == null) {
            return;
        }
        Kingdom k1 = u1.getKingdom();
        Kingdom k2 = u2.getKingdom();
        if (k1 == null || k2 == null) {
            return;
        }
        if (k1 != k2) {
            RelationType type;
            Relation rel = this.plugin.getKdc().getRelation(k1, k2);
            RelationType relationType = type = rel == null ? RelationType.NEUTRAL : rel.getType();
            if (!this.plugin.getKdc().getConfig().getFriendlyFireRelationTypes().contains((Object)type)) {
                return;
            }
        }
        FriendlyFireCancelEvent event = new FriendlyFireCancelEvent(p, d);
        this.plugin.getKdc().getEventManager().dispatch(event);
        if (event.isAllowed()) {
            return;
        }
        e.setCancelled(true);
        if (damager instanceof Arrow) {
            damager.remove();
        }
        long lastNotification = 0L;
        if (d.has("LAST_FRIENDLYFIRE_NOTIFICATION")) {
            lastNotification = d.get("LAST_FRIENDLYFIRE_NOTIFICATION", Long.class);
        }
        if (System.currentTimeMillis() - lastNotification > 5000L) {
            this.plugin.getKdc().getMessages().send((PlatformSender)d, "friendlyFire", new String[0]);
            d.set("LAST_FRIENDLYFIRE_NOTIFICATION", System.currentTimeMillis());
        }
    }
}

