/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.bukkit.listeners;

import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.events.PlayerLoadedEvent;
import com.gufli.kingdomcraft.api.events.UserJoinKingdomEvent;
import com.gufli.kingdomcraft.api.events.UserLeaveKingdomEvent;
import com.gufli.kingdomcraft.bukkit.KingdomCraftBukkitPlugin;
import com.gufli.kingdomcraft.bukkit.entity.BukkitPlayer;
import org.bukkit.entity.Player;

public class DisplayNameListener {
    private final KingdomCraftBukkitPlugin plugin;

    public DisplayNameListener(KingdomCraftBukkitPlugin plugin) {
        this.plugin = plugin;
        plugin.getKdc().getEventManager().addListener((Class)PlayerLoadedEvent.class, this::onLoad);
        plugin.getKdc().getEventManager().addListener((Class)UserJoinKingdomEvent.class, this::onKingdomJoin);
        plugin.getKdc().getEventManager().addListener((Class)UserLeaveKingdomEvent.class, this::onKingdomLeave);
    }

    public void onLoad(PlayerLoadedEvent event) {
        this.update(event.getPlayer());
    }

    public void onKingdomJoin(UserJoinKingdomEvent event) {
        PlatformPlayer player = this.plugin.getKdc().getPlayer(event.getUser());
        if (player != null) {
            this.update(player);
        }
    }

    public void onKingdomLeave(UserLeaveKingdomEvent event) {
        PlatformPlayer player = this.plugin.getKdc().getPlayer(event.getUser());
        if (player != null) {
            this.update(player);
        }
    }

    private void update(PlatformPlayer pp) {
        String suffix;
        if (!this.plugin.getKdc().getConfig().updateDisplayNames()) {
            return;
        }
        String prefix = this.plugin.getKdc().getPlaceholderManager().handle(pp, "{kingdom_prefix}");
        if (!prefix.equals("") && !this.plugin.decolorify(prefix).endsWith(" ")) {
            prefix = prefix + " ";
        }
        if (!(suffix = this.plugin.getKdc().getPlaceholderManager().handle(pp, "{kingdom_suffix}")).equals("") && !this.plugin.decolorify(suffix).startsWith(" ")) {
            suffix = " " + suffix;
        }
        Player player = ((BukkitPlayer)pp).getPlayer();
        if (prefix.equals("") && suffix.equals("")) {
            player.setDisplayName(player.getName());
            return;
        }
        prefix = this.plugin.colorify(prefix);
        suffix = this.plugin.colorify(suffix);
        player.setDisplayName(prefix + player.getName() + suffix);
    }
}

