/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.bukkit.listeners;

import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.bukkit.KingdomCraftBukkitPlugin;
import org.bukkit.Material;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class DeathListener
implements Listener {
    private final KingdomCraftBukkitPlugin plugin;

    public DeathListener(KingdomCraftBukkitPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onDeath(PlayerDeathEvent event) {
        if (event.getEntity().getKiller() != null && event.getEntity().getKiller() != event.getEntity()) {
            ItemMeta meta;
            PlatformPlayer p = this.plugin.getKdc().getPlayer(event.getEntity().getUniqueId());
            PlatformPlayer k = this.plugin.getKdc().getPlayer(event.getEntity().getKiller().getUniqueId());
            String msg = this.plugin.getKdc().getConfig().getOnKillMessage();
            ItemStack weapon = event.getEntity().getKiller().getItemInHand();
            if (weapon != null && weapon.getType() != Material.AIR && this.plugin.getKdc().getConfig().getOnKillWeaponMessage() != null && !this.plugin.getKdc().getConfig().getOnKillWeaponMessage().equals("") && (meta = weapon.getItemMeta()).getDisplayName() != null && !meta.getDisplayName().equals("")) {
                msg = this.plugin.getKdc().getConfig().getOnKillWeaponMessage();
                msg = msg.replace("{weapon}", this.plugin.colorify(meta.getDisplayName()));
            }
            if (msg == null) {
                return;
            }
            event.setDeathMessage(null);
            if (msg.equals("") || p == null || k == null) {
                return;
            }
            msg = this.plugin.getKdc().getPlaceholderManager().handle(p, msg);
            msg = this.plugin.getKdc().getPlaceholderManager().handle(k, msg, "killer_");
            msg = this.plugin.getKdc().getMessages().colorify(msg);
            event.setDeathMessage(msg);
            return;
        }
        if (this.plugin.getKdc().getConfig().getOnDeathMessage() == null) {
            return;
        }
        event.setDeathMessage(null);
        PlatformPlayer p = this.plugin.getKdc().getPlayer(event.getEntity().getUniqueId());
        if (this.plugin.getKdc().getConfig().getOnDeathMessage().equals("") || p == null) {
            return;
        }
        String msg = this.plugin.getKdc().getConfig().getOnDeathMessage();
        msg = this.plugin.getKdc().getPlaceholderManager().handle(p, msg);
        msg = this.plugin.getKdc().getMessages().colorify(msg);
        event.setDeathMessage(msg);
    }
}

