/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.bukkit.listeners;

import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.events.PlayerLoadedEvent;
import com.gufli.kingdomcraft.bukkit.KingdomCraftBukkitPlugin;
import com.gufli.kingdomcraft.bukkit.entity.BukkitPlayer;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class ConnectionListener
implements Listener {
    private final String kickMessage = ChatColor.GOLD + "[KingdomCraft]\n\n" + ChatColor.RED + "The server was unable to load your user data.\nTry joining again or contact an administrator!";
    private final KingdomCraftBukkitPlugin plugin;
    private final Map<UUID, Consumer<PlatformPlayer>> unregisterdPlayers = new ConcurrentHashMap<UUID, Consumer<PlatformPlayer>>();

    public ConnectionListener(KingdomCraftBukkitPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onLogin(AsyncPlayerPreLoginEvent e) {
        this.plugin.log("Loading " + e.getName());
        Consumer<PlatformPlayer> register = this.plugin.getKdc().onLogin(e.getUniqueId(), e.getName());
        if (register == null) {
            e.disallow(AsyncPlayerPreLoginEvent.Result.KICK_OTHER, this.kickMessage);
            return;
        }
        this.unregisterdPlayers.put(e.getUniqueId(), register);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onLoginMonitor(AsyncPlayerPreLoginEvent e) {
        if (e.getLoginResult() != AsyncPlayerPreLoginEvent.Result.ALLOWED) {
            this.unregisterdPlayers.remove(e.getUniqueId());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onQuit(PlayerQuitEvent e) {
        this.unregisterdPlayers.remove(e.getPlayer().getUniqueId());
        PlatformPlayer player = this.plugin.getKdc().getPlayer(e.getPlayer().getUniqueId());
        if (player != null) {
            this.plugin.getKdc().onQuit(player);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onJoin(PlayerJoinEvent e) {
        UUID id = e.getPlayer().getUniqueId();
        Consumer<PlatformPlayer> register = this.unregisterdPlayers.get(id);
        if (register == null && (register = this.plugin.getKdc().onLogin(id, e.getPlayer().getName())) == null) {
            this.plugin.log("The data for " + e.getPlayer().getName() + " was not pre-loaded, this is very very bad! Please contact the developer!", Level.SEVERE);
            e.getPlayer().kickPlayer(this.kickMessage);
            return;
        }
        BukkitPlayer pp = new BukkitPlayer(e.getPlayer());
        register.accept(pp);
        this.unregisterdPlayers.remove(id);
        this.plugin.getKdc().getEventManager().dispatch(new PlayerLoadedEvent(pp));
    }
}

