/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.bukkit.item;

import com.gufli.kingdomcraft.api.item.Item;
import com.gufli.kingdomcraft.api.item.ItemSerializer;
import com.gufli.kingdomcraft.bukkit.item.BukkitItem;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;

public class BukkitItemSerializer
implements Item.Serializer {
    public BukkitItemSerializer() {
        ItemSerializer.register(this);
    }

    @Override
    public Item deserialize(String value) {
        ItemStack is = BukkitItemSerializer.stringToItem(value);
        if (is == null) {
            return null;
        }
        return new BukkitItem(is);
    }

    @Override
    public String serialize(Item item) {
        if (item == null || item.getHandle() == null) {
            return null;
        }
        return BukkitItemSerializer.itemToString((ItemStack)item.getHandle());
    }

    public static String itemToString(ItemStack itemStack) {
        YamlConfiguration config = new YamlConfiguration();
        config.set("item", (Object)itemStack);
        return config.saveToString();
    }

    public static ItemStack stringToItem(String string) {
        YamlConfiguration config = new YamlConfiguration();
        try {
            config.loadFromString(string);
        }
        catch (Exception ignored) {
            return null;
        }
        return config.getItemStack("item", null);
    }
}

