/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.bukkit.gui.skull;

import com.gufli.kingdomcraft.bukkit.gui.skull.SkullBuilder;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.UUID;
import org.apache.commons.lang.RandomStringUtils;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.profile.PlayerProfile;

public class ModernSkullBuilder
implements SkullBuilder {
    @Override
    public void withSkullOwner(ItemStack itemStack, OfflinePlayer owner) {
        SkullMeta meta = (SkullMeta)itemStack.getItemMeta();
        meta.setOwningPlayer(owner);
        itemStack.setItemMeta((ItemMeta)meta);
    }

    @Override
    public void withSkullTexture(ItemStack itemStack, String texture) {
        try {
            this.withTexture(itemStack, new URL("https://textures.minecraft.net/texture/" + texture));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private void withProfile(ItemStack itemStack, PlayerProfile profile) {
        SkullMeta meta = (SkullMeta)itemStack.getItemMeta();
        meta.setOwnerProfile(profile);
        itemStack.setItemMeta((ItemMeta)meta);
    }

    private void withTexture(ItemStack itemStack, URL textureUrl) {
        PlayerProfile profile = Bukkit.createPlayerProfile((UUID)UUID.randomUUID(), (String)RandomStringUtils.randomAlphanumeric((int)16));
        profile.getTextures().setSkin(textureUrl);
        this.withProfile(itemStack, profile);
    }
}

