/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.bukkit.gui.skull;

import com.gufli.kingdomcraft.bukkit.gui.skull.SkullBuilder;
import com.gufli.kingdomcraft.bukkit.reflection.Reflection;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class LegacySkullBuilder
implements SkullBuilder {
    private static Class<?> GameProfile;
    private static Method GameProfile_getProperties;
    private static Class<?> Property;
    private static Method Property_getName;
    private static Method PropertyMap_put;
    private static Field CraftMetaSkull_profile;
    private static Method CraftMetaSkull_setOwningPlayer;

    @Override
    public void withSkullOwner(ItemStack itemStack, OfflinePlayer owner) {
        if (owner == null) {
            return;
        }
        SkullMeta meta = (SkullMeta)itemStack.getItemMeta();
        if (CraftMetaSkull_setOwningPlayer != null) {
            try {
                CraftMetaSkull_setOwningPlayer.invoke((Object)meta, owner);
                return;
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }
        meta.setOwner(owner.getName());
        itemStack.setItemMeta((ItemMeta)meta);
    }

    @Override
    public void withSkullTexture(ItemStack itemStack, String texture) {
        try {
            UUID uuid = UUID.randomUUID();
            Object profile = GameProfile.getDeclaredConstructor(UUID.class, String.class).newInstance(uuid, uuid.toString().substring(0, 15));
            Object property = Property.getDeclaredConstructor(String.class, String.class).newInstance("textures", texture);
            Object properties = GameProfile_getProperties.invoke(profile, new Object[0]);
            PropertyMap_put.invoke(properties, Property_getName.invoke(property, new Object[0]), property);
            this.withSkullProfile(itemStack, profile);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            ex.printStackTrace();
        }
    }

    private void withSkullProfile(ItemStack itemStack, Object profile) {
        try {
            SkullMeta meta = (SkullMeta)itemStack.getItemMeta();
            CraftMetaSkull_profile.set(meta, profile);
            itemStack.setItemMeta((ItemMeta)meta);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    static {
        try {
            GameProfile = Class.forName("com.mojang.authlib.GameProfile");
            GameProfile_getProperties = GameProfile.getDeclaredMethod("getProperties", new Class[0]);
            Property = Class.forName("com.mojang.authlib.properties.Property");
            Property_getName = Property.getMethod("getName", new Class[0]);
            Class<?> PropertyMap = Class.forName("com.mojang.authlib.properties.PropertyMap");
            PropertyMap_put = PropertyMap.getMethod("put", Object.class, Object.class);
            Class<?> CraftMetaSkull = Reflection.PackageType.CRAFTBUKKIT_INVENTORY.getClass("CraftMetaSkull");
            CraftMetaSkull_profile = CraftMetaSkull.getDeclaredField("profile");
            CraftMetaSkull_profile.setAccessible(true);
            try {
                CraftMetaSkull_setOwningPlayer = CraftMetaSkull.getMethod("setOwningPlayer", OfflinePlayer.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        catch (ClassNotFoundException | NoSuchFieldException | NoSuchMethodException e) {
            e.printStackTrace();
        }
    }
}

