/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.bukkit.gui;

import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.gui.InventoryItem;
import com.gufli.kingdomcraft.api.gui.InventoryItemCallback;
import com.gufli.kingdomcraft.bukkit.gui.BukkitInventory;
import com.gufli.kingdomcraft.bukkit.gui.BukkitInventoryItem;
import com.gufli.kingdomcraft.bukkit.gui.ItemStackBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class PaginationBuilder {
    private String title;
    private ItemStack previousItem;
    private ItemStack nextItem;
    private int itemAmount;
    private Function<Integer, BukkitInventoryItem> supplier;
    protected final Map<Integer, BukkitInventoryItem> hotbar = new HashMap<Integer, BukkitInventoryItem>();

    public static PaginationBuilder create() {
        return new PaginationBuilder();
    }

    public static PaginationBuilder create(String title) {
        return new PaginationBuilder().withTitle(title);
    }

    private PaginationBuilder() {
        this.previousItem = ItemStackBuilder.of(Material.ARROW).withName(ChatColor.GREEN + "Previous page").build();
        this.nextItem = ItemStackBuilder.of(Material.ARROW).withName(ChatColor.GREEN + "Next page").build();
    }

    public final PaginationBuilder withTitle(String title) {
        this.title = title;
        return this;
    }

    public PaginationBuilder withNextItem(ItemStack item) {
        this.nextItem = item;
        return this;
    }

    public PaginationBuilder withPreviousItem(ItemStack item) {
        this.previousItem = item;
        return this;
    }

    public PaginationBuilder withItems(int amount, Function<Integer, BukkitInventoryItem> supplier) {
        this.itemAmount = amount;
        this.supplier = supplier;
        return this;
    }

    public final PaginationBuilder withHotbarItem(int slot, BukkitInventoryItem item) {
        this.hotbar.put(slot, item);
        return this;
    }

    public final PaginationBuilder withHotbarItem(int slot, ItemStack item) {
        this.hotbar.put(slot, new BukkitInventoryItem(item));
        return this;
    }

    public final PaginationBuilder withHotbarItem(int slot, ItemStack item, InventoryItemCallback cb) {
        this.hotbar.put(slot, new BukkitInventoryItem(item, cb));
        return this;
    }

    public BukkitInventory build() {
        BiConsumer<PlatformPlayer, Integer> openCallback = new BiConsumer<PlatformPlayer, Integer>(){

            @Override
            public void accept(PlatformPlayer player, Integer pageNumber) {
                player.openInventory(PaginationBuilder.this.page(pageNumber, this));
            }
        };
        return this.build(openCallback);
    }

    public void buildAsync(PlatformPlayer player, final Executor sync, final Executor async) {
        if (this.supplier == null) {
            throw new IllegalStateException("Supplier may not be null.");
        }
        BiConsumer<PlatformPlayer, Integer> openCallback = new BiConsumer<PlatformPlayer, Integer>(){

            @Override
            public void accept(PlatformPlayer player, Integer pageNumber) {
                async.execute(() -> {
                    BukkitInventory pageInv = PaginationBuilder.this.page(pageNumber, this);
                    sync.execute(() -> player.openInventory(pageInv));
                });
            }
        };
        async.execute(() -> {
            BukkitInventory inv = this.build(openCallback);
            sync.execute(() -> player.openInventory(inv));
        });
    }

    private BukkitInventory build(BiConsumer<PlatformPlayer, Integer> openCallback) {
        if (this.supplier == null) {
            throw new IllegalStateException("Supplier may not be null.");
        }
        int size = this.itemAmount / 9 + (this.itemAmount % 9 > 0 ? 1 : 0);
        if (!this.hotbar.isEmpty()) {
            size += 2;
        }
        if (size <= 6) {
            BukkitInventory menu = new BukkitInventory(size * 9, this.title);
            for (int i = 0; i < this.itemAmount; ++i) {
                menu.setItem(i, (InventoryItem)this.supplier.apply(i));
            }
            for (int slot : this.hotbar.keySet()) {
                if (slot < 0 || slot >= 9) continue;
                menu.setItem((size - 1) * 9 + slot, (InventoryItem)this.hotbar.get(slot));
            }
            return menu;
        }
        return this.page(0, openCallback);
    }

    private BukkitInventory page(int page, BiConsumer<PlatformPlayer, Integer> openCallback) {
        int rows = this.itemAmount / 9 + (this.itemAmount % 9 > 0 ? 1 : 0);
        int pages = rows / 4 + (rows % 4 > 0 ? 1 : 0);
        BukkitInventory menu = new BukkitInventory(54, this.title);
        int offset = page * 36;
        for (int i = 0; i < Math.min(this.itemAmount - offset, 36); ++i) {
            menu.setItem(i, (InventoryItem)this.supplier.apply(offset + i));
        }
        for (int slot : this.hotbar.keySet()) {
            if (slot >= 9) continue;
            menu.setItem(45 + slot, (InventoryItem)this.hotbar.get(slot));
        }
        if (page > 0) {
            menu.setItem(47, new BukkitInventoryItem(this.previousItem, (player, clickType) -> {
                openCallback.accept(player, page - 1);
                return true;
            }));
        }
        if (page < pages - 1) {
            menu.setItem(51, new BukkitInventoryItem(this.nextItem, (player, clickType) -> {
                openCallback.accept(player, page + 1);
                return true;
            }));
        }
        return menu;
    }
}

