/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.bukkit.gui;

import java.util.ArrayList;
import java.util.List;

public class MenuScheme {
    private static final int width = 9;
    private final String[] mask;

    public MenuScheme(String ... rows) {
        for (int i = 0; i < rows.length; ++i) {
            if (rows[i].length() == 9) continue;
            throw new IllegalStateException("Invalid row " + i + ", width must be " + 9);
        }
        this.mask = rows;
    }

    public int getRows() {
        return this.mask.length;
    }

    public boolean isMasked(int slot) {
        int row = slot / 9;
        int pos = slot % 9;
        if (row >= this.mask.length) {
            return false;
        }
        return this.mask[row].charAt(pos) == '1';
    }

    public List<Integer> getSlots() {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (int row = 0; row < this.mask.length; ++row) {
            for (int pos = 0; pos < 9; ++pos) {
                if (this.mask[row].charAt(pos) != '1') continue;
                slots.add(row * 9 + pos);
            }
        }
        return slots;
    }
}

