/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.bukkit.gui;

import com.gufli.kingdomcraft.api.KingdomCraftProvider;
import com.gufli.kingdomcraft.bukkit.gui.skull.LegacySkullBuilder;
import com.gufli.kingdomcraft.bukkit.gui.skull.ModernSkullBuilder;
import com.gufli.kingdomcraft.bukkit.gui.skull.SkullBuilder;
import com.gufli.kingdomcraft.bukkit.reflection.VersionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.FireworkEffect;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class ItemStackBuilder {
    private final ItemStack itemStack;
    private static final SkullBuilder skullBuilder = VersionUtils.isMcGreaterOrEqualTo("1.17") ? new ModernSkullBuilder() : new LegacySkullBuilder();

    public static ItemStackBuilder of(Material material) {
        return new ItemStackBuilder(new ItemStack(material)).hideAttributes();
    }

    public static ItemStackBuilder of(ItemStack itemStack) {
        return new ItemStackBuilder(itemStack).hideAttributes();
    }

    public static ItemStackBuilder of(String material, String fallback) {
        try {
            return ItemStackBuilder.of(Material.valueOf((String)material));
        }
        catch (IllegalArgumentException ex) {
            return ItemStackBuilder.of(Material.valueOf((String)fallback));
        }
    }

    public static ItemStackBuilder of(String material, String fallback, int data) {
        try {
            return ItemStackBuilder.of(Material.valueOf((String)material));
        }
        catch (IllegalArgumentException ex) {
            return ItemStackBuilder.of(Material.valueOf((String)fallback)).withDurability(data);
        }
    }

    public static ItemStackBuilder skull() {
        return ItemStackBuilder.of("PLAYER_HEAD", "SKULL_ITEM", 3);
    }

    public static ItemStackBuilder wool(ItemColor color) {
        return ItemStackBuilder.of(color.name() + "_WOOL", "WOOL", color.data);
    }

    public static ItemStackBuilder terracotta(ItemColor color) {
        return ItemStackBuilder.of(color.name() + "_TERRACOTTA", "STAINED_CLAY", color.data);
    }

    public static ItemStackBuilder glass(ItemColor color) {
        return ItemStackBuilder.of(color.name() + "_STAINED_GLASS", "STAINED_GLASS", color.data);
    }

    public static ItemStackBuilder bed(ItemColor color) {
        return ItemStackBuilder.of(color.name() + "_BED", "BED", color.data);
    }

    public static ItemStackBuilder carpet(ItemColor color) {
        return ItemStackBuilder.of(color.name() + "_CARPET", "CARPET", color.data);
    }

    public static ItemStackBuilder dye(ItemColor color) {
        return ItemStackBuilder.of(color.name() + "_DYE", "INK_SACK", color.data);
    }

    public static ItemStackBuilder banner(ItemColor color) {
        try {
            return ItemStackBuilder.of(Material.valueOf((String)(color.name() + "_BANNER")));
        }
        catch (IllegalArgumentException ex) {
            return ItemStackBuilder.of(Material.valueOf((String)"BANNER")).transformMeta(BannerMeta.class, bannerMeta -> bannerMeta.setBaseColor(DyeColor.valueOf((String)color.name())));
        }
    }

    private ItemStackBuilder(ItemStack itemStack) {
        this.itemStack = Objects.requireNonNull(itemStack, "itemStack");
    }

    public ItemStack build() {
        return this.itemStack;
    }

    public ItemStackBuilder transform(Consumer<ItemStack> is) {
        is.accept(this.itemStack);
        return this;
    }

    public ItemStackBuilder transformMeta(Consumer<ItemMeta> meta) {
        return this.transformMeta(ItemMeta.class, meta);
    }

    public <T extends ItemMeta> ItemStackBuilder transformMeta(Class<T> type, Consumer<T> meta) {
        ItemMeta m3 = this.itemStack.getItemMeta();
        if (m3 != null) {
            meta.accept(m3);
            this.itemStack.setItemMeta(m3);
        }
        return this;
    }

    public ItemStackBuilder apply(Consumer<ItemStackBuilder> consumer) {
        consumer.accept(this);
        return this;
    }

    public ItemStackBuilder apply(boolean condition, Consumer<ItemStackBuilder> consumer) {
        if (condition) {
            consumer.accept(this);
        }
        return this;
    }

    public ItemStackBuilder apply(Supplier<Boolean> condition, Consumer<ItemStackBuilder> consumer) {
        return this.apply(condition.get(), consumer);
    }

    public ItemStackBuilder withName(String name) {
        return this.transformMeta(meta -> meta.setDisplayName(name));
    }

    public ItemStackBuilder withType(Material material) {
        return this.transform(itemStack -> itemStack.setType(material));
    }

    public ItemStackBuilder withLore(String ... lines) {
        return this.withLore(Arrays.asList(lines));
    }

    public ItemStackBuilder withLore(Iterable<String> lines) {
        return this.transformMeta(meta -> {
            List<String> lore = meta.getLore() == null ? new ArrayList() : meta.getLore();
            for (String line : lines) {
                String[] split;
                for (String s2 : split = line.split("\n")) {
                    lore.add(KingdomCraftProvider.get().colorify(s2));
                }
            }
            meta.setLore(lore);
        });
    }

    public ItemStackBuilder clearLore() {
        return this.transformMeta(meta -> meta.setLore(new ArrayList()));
    }

    public ItemStackBuilder withDurability(int durability) {
        return this.transform(itemStack -> itemStack.setDurability((short)durability));
    }

    public ItemStackBuilder withData(int data) {
        return this.withDurability(data);
    }

    public ItemStackBuilder withAmount(int amount) {
        return this.transform(itemStack -> itemStack.setAmount(amount));
    }

    public ItemStackBuilder withEnchantment(Enchantment enchantment, int level) {
        return this.transform(itemStack -> itemStack.addUnsafeEnchantment(enchantment, level));
    }

    public ItemStackBuilder withEnchantment(Enchantment enchantment) {
        return this.transform(itemStack -> itemStack.addUnsafeEnchantment(enchantment, 1));
    }

    public ItemStackBuilder clearEnchantments() {
        return this.transform(itemStack -> itemStack.getEnchantments().keySet().forEach(arg_0 -> ((ItemStack)itemStack).removeEnchantment(arg_0)));
    }

    public ItemStackBuilder withItemFlag(ItemFlag ... flags) {
        return this.transformMeta(meta -> meta.addItemFlags(flags));
    }

    public ItemStackBuilder withoutItemFlag(ItemFlag ... flags) {
        return this.transformMeta(meta -> meta.removeItemFlags(flags));
    }

    public ItemStackBuilder hideAttributes() {
        return this.withItemFlag(ItemFlag.values());
    }

    public ItemStackBuilder showAttributes() {
        return this.withoutItemFlag(ItemFlag.values());
    }

    public ItemStackBuilder withLeatherColor(Color color) {
        Material type = this.itemStack.getType();
        if (type != Material.LEATHER_BOOTS && type != Material.LEATHER_CHESTPLATE && type != Material.LEATHER_HELMET && type != Material.LEATHER_LEGGINGS) {
            return this;
        }
        return this.transformMeta(LeatherArmorMeta.class, meta -> meta.setColor(color));
    }

    public ItemStackBuilder withSkullOwner(OfflinePlayer owner) {
        skullBuilder.withSkullOwner(this.itemStack, owner);
        return this;
    }

    public ItemStackBuilder withSkullTexture(String texture) {
        skullBuilder.withSkullTexture(this.itemStack, texture);
        return this;
    }

    public ItemStackBuilder withPattern(Pattern pattern) {
        return this.transformMeta(BannerMeta.class, meta -> meta.addPattern(pattern));
    }

    public ItemStackBuilder withPattern(DyeColor color, PatternType type) {
        return this.transformMeta(BannerMeta.class, meta -> meta.addPattern(new Pattern(color, type)));
    }

    public ItemStackBuilder setPattern(int layer, Pattern pattern) {
        return this.transformMeta(BannerMeta.class, meta -> meta.setPattern(layer, pattern));
    }

    public ItemStackBuilder setPattern(int layer, DyeColor color, PatternType type) {
        return this.transformMeta(BannerMeta.class, meta -> meta.setPattern(layer, new Pattern(color, type)));
    }

    public ItemStackBuilder withPatterns(Pattern ... patterns) {
        return this.withPatterns(Arrays.asList(patterns));
    }

    public ItemStackBuilder withPatterns(List<Pattern> patterns) {
        return this.transformMeta(BannerMeta.class, meta -> meta.setPatterns(patterns));
    }

    public ItemStackBuilder withAuthor(String author) {
        return this.transformMeta(BookMeta.class, meta -> meta.setAuthor(author));
    }

    public ItemStackBuilder withTitle(String title) {
        return this.transformMeta(BookMeta.class, meta -> meta.setTitle(title));
    }

    public ItemStackBuilder withPage(String contents) {
        return this.transformMeta(BookMeta.class, meta -> meta.addPage(new String[]{contents}));
    }

    public ItemStackBuilder withPages(String ... contents) {
        return this.transformMeta(BookMeta.class, meta -> meta.setPages(contents));
    }

    public ItemStackBuilder withPages(List<String> contents) {
        return this.transformMeta(BookMeta.class, meta -> meta.setPages(contents));
    }

    public ItemStackBuilder withFireworkPower(int power) {
        return this.transformMeta(FireworkMeta.class, meta -> meta.setPower(power));
    }

    public ItemStackBuilder withFireworkEffect(FireworkEffect effect) {
        return this.transformMeta(FireworkMeta.class, meta -> meta.addEffect(effect));
    }

    public ItemStackBuilder withFireworkEffects(FireworkEffect ... effects) {
        return this.withFireworkEffects(Arrays.asList(effects));
    }

    public ItemStackBuilder withFireworkEffects(List<FireworkEffect> effects) {
        return this.transformMeta(FireworkMeta.class, meta -> {
            meta.clearEffects();
            meta.addEffects((Iterable)effects);
        });
    }

    public ItemStackBuilder withPotionEffect(PotionEffect effect) {
        return this.transformMeta(PotionMeta.class, meta -> meta.addCustomEffect(effect, true));
    }

    public ItemStackBuilder withPotionEffects(PotionEffect ... effects) {
        return this.withPotionEffects(Arrays.asList(effects));
    }

    public ItemStackBuilder withPotionEffects(List<PotionEffect> effects) {
        return this.transformMeta(PotionMeta.class, meta -> {
            for (PotionEffect effect : effects) {
                meta.addCustomEffect(effect, true);
            }
        });
    }

    public ItemStackBuilder withPotionEffect(PotionEffectType type) {
        return this.transformMeta(PotionMeta.class, meta -> meta.addCustomEffect(new PotionEffect(type, 1200, 0), true));
    }

    public ItemStackBuilder withPotionEffect(PotionEffectType type, int duration) {
        return this.transformMeta(PotionMeta.class, meta -> meta.addCustomEffect(new PotionEffect(type, duration, 0), true));
    }

    public ItemStackBuilder withPotionEffect(PotionEffectType type, int duration, int amplifier) {
        return this.transformMeta(PotionMeta.class, meta -> meta.addCustomEffect(new PotionEffect(type, duration, amplifier), true));
    }

    public ItemStackBuilder withPotionEffect(PotionEffectType type, int duration, int amplifier, boolean ambient) {
        return this.transformMeta(PotionMeta.class, meta -> meta.addCustomEffect(new PotionEffect(type, duration, amplifier, ambient), true));
    }

    public ItemStackBuilder withPotionEffect(PotionEffectType type, int duration, int amplifier, boolean ambient, boolean particles) {
        return this.transformMeta(PotionMeta.class, meta -> meta.addCustomEffect(new PotionEffect(type, duration, amplifier, ambient, particles), true));
    }

    public static enum ItemColor {
        WHITE(0),
        ORANGE(1),
        MAGENTA(2),
        LIGHT_BLUE(3),
        YELLOW(4),
        LIME(5),
        PINK(6),
        GRAY(7),
        LIGHT_GRAY(8),
        CYAN(9),
        PURPLE(10),
        BLUE(11),
        BROWN(12),
        GREEN(13),
        RED(14),
        BLACK(15);

        public final int data;

        private ItemColor(int data) {
            this.data = data;
        }
    }
}

