/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.bukkit.gui;

import com.gufli.kingdomcraft.api.KingdomCraft;
import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.events.PlayerLeaveEvent;
import com.gufli.kingdomcraft.api.gui.Inventory;
import com.gufli.kingdomcraft.api.gui.InventoryClickType;
import com.gufli.kingdomcraft.bukkit.KingdomCraftBukkitPlugin;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;

public class InventoryListener
implements Listener {
    private final KingdomCraft kdc;

    public InventoryListener(KingdomCraftBukkitPlugin plugin) {
        this.kdc = plugin.getKdc();
        this.kdc.getEventManager().addListener(PlayerLeaveEvent.class, e -> this.handleClose(e.getPlayer()));
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent e) {
        if (!(e.getPlayer() instanceof Player)) {
            return;
        }
        PlatformPlayer player = this.kdc.getPlayer(e.getPlayer().getUniqueId());
        if (player == null) {
            return;
        }
        this.handleClose(player);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent e) {
        Sound sound;
        if (!(e.getWhoClicked() instanceof Player)) {
            return;
        }
        PlatformPlayer player = this.kdc.getPlayer(e.getWhoClicked().getUniqueId());
        if (player == null) {
            return;
        }
        Inventory<?, ?> inv = player.getInventory();
        if (inv == null || inv.getHandle() == null) {
            return;
        }
        if (e.getRawSlot() >= e.getView().getTopInventory().getSize()) {
            return;
        }
        e.setCancelled(true);
        InventoryClickType type = null;
        switch (e.getClick()) {
            case DOUBLE_CLICK: 
            case SHIFT_LEFT: 
            case LEFT: {
                type = InventoryClickType.LEFT;
                break;
            }
            case SHIFT_RIGHT: 
            case RIGHT: {
                type = InventoryClickType.RIGHT;
                break;
            }
            case MIDDLE: {
                type = InventoryClickType.MIDDLE;
            }
        }
        if (type == null) {
            return;
        }
        boolean playSound = false;
        try {
            playSound = inv.dispatchClick(player, type, e.getRawSlot());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (!playSound) {
            return;
        }
        try {
            sound = Sound.valueOf((String)"CLICK");
        }
        catch (IllegalArgumentException ex) {
            sound = Sound.valueOf((String)"UI_BUTTON_CLICK");
        }
        Player p = (Player)e.getWhoClicked();
        p.playSound(p.getLocation().add(0.0, 1.8, 0.0), sound, 1.0f, 1.0f);
    }

    private void handleClose(PlatformPlayer player) {
        Inventory<?, ?> inv = player.getInventory();
        if (inv != null) {
            inv.dispatchClose(player);
            player.set("CUSTOM_GUI", null);
        }
    }
}

