/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.bukkit.gui;

import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.gui.InventoryClickType;
import com.gufli.kingdomcraft.api.gui.InventoryItem;
import com.gufli.kingdomcraft.api.gui.InventoryItemCallback;
import com.gufli.kingdomcraft.bukkit.gui.BukkitInventory;
import com.gufli.kingdomcraft.bukkit.gui.BukkitInventoryItem;
import com.gufli.kingdomcraft.bukkit.gui.MenuScheme;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.bukkit.inventory.ItemStack;

public class InventoryBuilder {
    private static final MenuScheme[] SCHEMES = new MenuScheme[]{new MenuScheme("000000000", "000010000"), new MenuScheme("000000000", "000101000"), new MenuScheme("000000000", "001010100"), new MenuScheme("000000000", "010101010"), new MenuScheme("000000000", "001010100", "000101000"), new MenuScheme("000000000", "001010100", "001010100"), new MenuScheme("000000000", "010101010", "001010100"), new MenuScheme("000000000", "010101010", "010101010"), new MenuScheme("000000000", "001010100", "001010100", "001010100"), new MenuScheme("000000000", "001010100", "010101010", "001010100")};
    private static final MenuScheme[] ROW_SCHEMES = new MenuScheme[]{new MenuScheme("000010000"), new MenuScheme("000101000"), new MenuScheme("001010100"), new MenuScheme("010101010"), new MenuScheme("101010101"), new MenuScheme("011101110"), new MenuScheme("011111110"), new MenuScheme("111101111"), new MenuScheme("111111111")};
    protected String title;
    protected final List<BukkitInventoryItem> items = new ArrayList<BukkitInventoryItem>();
    protected final Map<Integer, BukkitInventoryItem> hotbar = new HashMap<Integer, BukkitInventoryItem>();

    protected InventoryBuilder() {
    }

    public static InventoryBuilder create() {
        return new InventoryBuilder();
    }

    public static InventoryBuilder create(String title) {
        return new InventoryBuilder().withTitle(title);
    }

    public final InventoryBuilder withTitle(String title) {
        this.title = title;
        return this;
    }

    public final InventoryBuilder withItem(ItemStack item) {
        this.items.add(new BukkitInventoryItem(item));
        return this;
    }

    public final InventoryBuilder withItems(ItemStack ... items) {
        return this.withItems(Arrays.asList(items));
    }

    public final InventoryBuilder withItems(Iterable<ItemStack> items) {
        for (ItemStack item : items) {
            this.items.add(new BukkitInventoryItem(item));
        }
        return this;
    }

    public final InventoryBuilder withItem(ItemStack item, InventoryItemCallback cb) {
        this.items.add(new BukkitInventoryItem(item, cb));
        return this;
    }

    public final InventoryBuilder withItem(ItemStack item, BiConsumer<PlatformPlayer, InventoryClickType> cb) {
        this.items.add(new BukkitInventoryItem(item, (player, clickType) -> {
            cb.accept(player, clickType);
            return true;
        }));
        return this;
    }

    public final InventoryBuilder withHotbarItem(int slot, BukkitInventoryItem item) {
        this.hotbar.put(slot, item);
        return this;
    }

    public final InventoryBuilder withHotbarItem(int slot, ItemStack item) {
        this.hotbar.put(slot, new BukkitInventoryItem(item));
        return this;
    }

    public final InventoryBuilder withHotbarItem(int slot, ItemStack item, InventoryItemCallback cb) {
        this.hotbar.put(slot, new BukkitInventoryItem(item, cb));
        return this;
    }

    public BukkitInventory buildRow() {
        if (this.items.size() > 9) {
            throw new UnsupportedOperationException("More than 9 items is not supported.");
        }
        MenuScheme scheme = ROW_SCHEMES[this.items.size() - 1];
        return this.build(scheme);
    }

    public BukkitInventory build() {
        if (this.items.size() > 10) {
            throw new UnsupportedOperationException("More than 10 items is not supported.");
        }
        MenuScheme scheme = SCHEMES[this.items.size() - 1];
        return this.build(scheme);
    }

    private BukkitInventory build(MenuScheme scheme) {
        int size = scheme.getRows();
        if (!this.hotbar.isEmpty()) {
            size += 2;
        } else if (size != 1) {
            ++size;
        }
        BukkitInventory menu = new BukkitInventory(size * 9, this.title);
        Iterator<Integer> slots = scheme.getSlots().iterator();
        for (BukkitInventoryItem item : this.items) {
            if (!slots.hasNext()) break;
            menu.setItem((int)slots.next(), item);
        }
        Iterator<Object> iterator = this.hotbar.keySet().iterator();
        while (iterator.hasNext()) {
            int slot = (Integer)iterator.next();
            if (slot < 0 || slot >= 9) continue;
            menu.setItem((size - 1) * 9 + slot, (InventoryItem)this.hotbar.get(slot));
        }
        return menu;
    }
}

