/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.bukkit.entity;

import com.gufli.kingdomcraft.api.entity.PlatformLocation;
import com.gufli.kingdomcraft.api.gui.Inventory;
import com.gufli.kingdomcraft.bukkit.util.LocationConverter;
import com.gufli.kingdomcraft.common.entity.AbstractPlatformPlayer;
import java.util.UUID;
import org.bukkit.entity.Player;

public class BukkitPlayer
extends AbstractPlatformPlayer {
    private final Player player;

    public BukkitPlayer(Player player) {
        this.player = player;
    }

    public Player getPlayer() {
        return this.player;
    }

    public boolean equals(Object obj) {
        return obj instanceof BukkitPlayer && ((BukkitPlayer)obj).player == this.player;
    }

    @Override
    public UUID getUniqueId() {
        return this.player.getUniqueId();
    }

    @Override
    public String getName() {
        return this.player.getName();
    }

    @Override
    public void teleport(PlatformLocation location) {
        this.player.teleport(LocationConverter.convert(location));
    }

    @Override
    public PlatformLocation getLocation() {
        return LocationConverter.convert(this.player.getLocation());
    }

    @Override
    public boolean hasPermission(String permission) {
        return this.player.hasPermission(permission);
    }

    @Override
    public void sendMessage(String msg) {
        this.player.sendMessage(msg);
    }

    @Override
    public void openInventory(Inventory<?, ?> inventory) {
        if (inventory.getHandle() instanceof org.bukkit.inventory.Inventory) {
            this.player.openInventory((org.bukkit.inventory.Inventory)inventory.getHandle());
            super.openInventory(inventory);
        }
    }

    @Override
    public void closeInventory() {
        this.player.closeInventory();
    }
}

