/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.bukkit.commands;

import com.gufli.kingdomcraft.api.domain.Kingdom;
import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.entity.PlatformSender;
import com.gufli.kingdomcraft.bukkit.entity.BukkitPlayer;
import com.gufli.kingdomcraft.bukkit.item.BukkitItem;
import com.gufli.kingdomcraft.common.KingdomCraftImpl;
import com.gufli.kingdomcraft.common.command.CommandBase;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class EditItemOtherCommand
extends CommandBase {
    public EditItemOtherCommand(KingdomCraftImpl kdc) {
        super(kdc, "edit item", 1, true);
        this.setArgumentsHint("<kingdom>");
        this.setExplanationMessage(() -> kdc.getMessages().getMessage("cmdEditItemOtherExplanation"));
        this.setPermissions("kingdom.edit.item.other");
    }

    @Override
    public List<String> autocomplete(PlatformPlayer sender, String[] args) {
        if (args.length == 1) {
            return this.kdc.getKingdoms(true).stream().map(Kingdom::getName).collect(Collectors.toList());
        }
        return null;
    }

    @Override
    public void execute(PlatformSender sender, String[] args) {
        Kingdom kingdom = this.kdc.getKingdom(args[0]);
        if (kingdom == null) {
            this.kdc.getMessages().send(sender, "cmdErrorKingdomNotExist", args[0]);
            return;
        }
        ItemStack item = ((BukkitPlayer)sender).getPlayer().getItemInHand();
        if (item == null || item.getType() == Material.AIR) {
            this.kdc.getMessages().send(sender, "cmdEditItemInvalid", new String[0]);
            return;
        }
        kingdom.setItem(new BukkitItem(item));
        this.kdc.saveAsync(kingdom);
        this.kdc.getMessages().send(sender, "cmdEditOther", "item", kingdom.getName(), item.getType().name());
    }
}

