/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.bukkit.commands;

import com.gufli.kingdomcraft.api.domain.Kingdom;
import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.entity.PlatformSender;
import com.gufli.kingdomcraft.bukkit.entity.BukkitPlayer;
import com.gufli.kingdomcraft.bukkit.item.BukkitItem;
import com.gufli.kingdomcraft.common.KingdomCraftImpl;
import com.gufli.kingdomcraft.common.command.CommandBase;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class EditItemCommand
extends CommandBase {
    public EditItemCommand(KingdomCraftImpl kdc) {
        super(kdc, "edit item", 0, true);
        this.setExplanationMessage(() -> kdc.getMessages().getMessage("cmdEditItemExplanation"));
        this.setPermissions("kingdom.edit.item");
    }

    @Override
    public List<String> autocomplete(PlatformPlayer player, String[] args) {
        return null;
    }

    @Override
    public void execute(PlatformSender sender, String[] args) {
        PlatformPlayer player = (PlatformPlayer)sender;
        Kingdom kingdom = player.getUser().getKingdom();
        if (kingdom == null) {
            this.kdc.getMessages().send(sender, "cmdErrorSenderNoKingdom", new String[0]);
            return;
        }
        ItemStack item = ((BukkitPlayer)player).getPlayer().getItemInHand();
        if (item == null || item.getType() == Material.AIR) {
            this.kdc.getMessages().send(sender, "cmdEditItemInvalid", new String[0]);
            return;
        }
        kingdom.setItem(new BukkitItem(item));
        this.kdc.saveAsync(kingdom);
        this.kdc.getMessages().send(sender, "cmdEdit", "item", item.getType().name());
    }
}

