/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.bukkit.command;

import com.gufli.kingdomcraft.api.entity.PlatformSender;
import com.gufli.kingdomcraft.bukkit.KingdomCraftBukkitPlugin;
import com.gufli.kingdomcraft.bukkit.commands.EditItemCommand;
import com.gufli.kingdomcraft.bukkit.commands.EditItemOtherCommand;
import com.gufli.kingdomcraft.bukkit.commands.ReloadCommand;
import com.gufli.kingdomcraft.bukkit.commands.VersionCommand;
import com.gufli.kingdomcraft.bukkit.entity.BukkitSender;
import com.gufli.kingdomcraft.bukkit.menu.InfoCommand;
import com.gufli.kingdomcraft.bukkit.menu.MenuCommand;
import com.gufli.kingdomcraft.common.KingdomCraftImpl;
import com.gufli.kingdomcraft.common.command.CommandManagerImpl;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class CommandHandler
implements CommandExecutor,
TabCompleter {
    private final KingdomCraftBukkitPlugin plugin;
    private final KingdomCraftImpl kdc;

    public CommandHandler(KingdomCraftBukkitPlugin plugin) {
        this.plugin = plugin;
        this.kdc = plugin.getKdc();
        CommandManagerImpl cm = plugin.getKdc().getCommandManager();
        cm.addCommand(new ReloadCommand(plugin));
        cm.addCommand(new VersionCommand(plugin));
        cm.addCommand(new MenuCommand(this.kdc));
        cm.addCommand(new InfoCommand(this.kdc));
        cm.addCommand(new EditItemCommand(this.kdc));
        cm.addCommand(new EditItemOtherCommand(this.kdc));
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            String prefix = this.kdc.getMessages().colorify(this.kdc.getMessages().getPrefix());
            sender.sendMessage(prefix + this.kdc.getMessages().getMessage("cmdDefaultHelp"));
            return true;
        }
        this.kdc.getCommandManager().dispatch(this.wrap(sender), args);
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!(sender instanceof Player)) {
            return null;
        }
        return this.kdc.getCommandManager().dispatchAutocomplete(this.kdc.getPlayer(((Player)sender).getUniqueId()), args);
    }

    private PlatformSender wrap(CommandSender sender) {
        if (sender instanceof Player) {
            return this.kdc.getPlayer(((Player)sender).getUniqueId());
        }
        return new BukkitSender(sender);
    }
}

