/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.bukkit.chat;

import com.gufli.kingdomcraft.api.chat.ChatChannel;
import com.gufli.kingdomcraft.api.domain.User;
import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.event.EventSubscription;
import com.gufli.kingdomcraft.api.events.PlayerChatEvent;
import com.gufli.kingdomcraft.bukkit.KingdomCraftBukkitPlugin;
import com.gufli.kingdomcraft.bukkit.entity.OfflineBukkitPlayer;
import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.api.Subscribe;
import github.scarsz.discordsrv.api.events.DiscordGuildMessagePreProcessEvent;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class DiscordSRVHandler {
    private final KingdomCraftBukkitPlugin plugin;
    private final EventSubscription<?> subscription;

    public DiscordSRVHandler(KingdomCraftBukkitPlugin plugin) {
        this.plugin = plugin;
        plugin.getLogger().info("Enabling DiscordSRV integration...");
        this.subscription = plugin.getKdc().getEventManager().addListener((Class)PlayerChatEvent.class, this::onChat);
        DiscordSRV.api.subscribe((Object)this);
    }

    public void disable() {
        this.subscription.unregister();
        DiscordSRV.api.unsubscribe((Object)this);
    }

    private void onChat(PlayerChatEvent event) {
        if (DiscordSRV.getPlugin().getDestinationTextChannelForGameChannelName(event.getChatChannel().getName()) == null) {
            DiscordSRV.debug((String)("Tried looking up destination Discord channel for KingdomCraft channel " + event.getChatChannel().getName() + " but none found."));
            return;
        }
        if (event.getPlayer().has("DISCORDSRV_IGNORE") && event.getMessage().equals(event.getPlayer().get("DISCORDSRV_IGNORE", String.class))) {
            event.getPlayer().remove("DISCORDSRV_IGNORE");
            return;
        }
        Player player = Bukkit.getPlayer((UUID)event.getPlayer().getUniqueId());
        if (player == null) {
            return;
        }
        DiscordSRV.getPlugin().processChatMessage(player, event.getMessage(), event.getChatChannel().getName(), event.isCancelled());
    }

    @Subscribe
    public void onDiscordChat(DiscordGuildMessagePreProcessEvent event) {
        if (event.isCancelled()) {
            return;
        }
        String channel = DiscordSRV.getPlugin().getDestinationGameChannelNameForTextChannel(event.getChannel());
        if (channel == null) {
            DiscordSRV.debug((String)("Tried looking up destination KingdomCraft channel for Discord channel " + event.getChannel().getName() + " but none found."));
            return;
        }
        ChatChannel cc = this.plugin.getKdc().getChatManager().getChatChannel(channel);
        if (cc == null) {
            return;
        }
        this.plugin.getScheduler().makeAsyncFuture(() -> {
            github.scarsz.discordsrv.dependencies.jda.api.entities.User discordUser = event.getAuthor();
            UUID uuid = DiscordSRV.getPlugin().getAccountLinkManager().getUuid(discordUser.getId());
            if (uuid == null) {
                return;
            }
            User kingdomUser = this.plugin.getKdc().getUser(uuid).join();
            if (kingdomUser == null) {
                return;
            }
            PlatformPlayer pp = this.plugin.getKdc().getPlayer(kingdomUser);
            if (pp == null) {
                pp = new OfflineBukkitPlayer(Bukkit.getOfflinePlayer((UUID)uuid), kingdomUser);
            }
            String message = event.getMessage().getContentStripped();
            pp.set("DISCORDSRV_IGNORE", message);
            this.plugin.getKdc().getChatManager().dispatch(pp, cc, message);
        }).exceptionally(e -> {
            e.printStackTrace();
            return null;
        });
    }
}

