/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.bukkit;

import com.gufli.kingdomcraft.bukkit.config.BukkitConfiguration;
import com.gufli.kingdomcraft.common.config.Configuration;
import com.gufli.kingdomcraft.common.messages.MessagesImpl;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class MessagesLoader {
    private static final String[] defaultLanguages = new String[]{"en", "nl", "es"};

    public static void load(MessagesImpl messages, ClassLoader classLoader, File directory, String language) {
        for (String lang : defaultLanguages) {
            URL inurl;
            File outFile = new File(directory, lang + ".yml");
            if (outFile.exists() || (inurl = classLoader.getResource("languages/" + lang + ".yml")) == null) continue;
            try (InputStream in = inurl.openStream();
                 FileOutputStream out = new FileOutputStream(outFile);){
                int len;
                byte[] buf = new byte[1024];
                while ((len = in.read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        ArrayList<Configuration> configs = new ArrayList<Configuration>();
        URL defaultFallback = classLoader.getResource("languages/en.yml");
        Configuration defaultFallbackConfig = MessagesLoader.loadResource(defaultFallback);
        configs.add(defaultFallbackConfig);
        URL fallback = classLoader.getResource("languages/" + language + ".yml");
        if (fallback != null) {
            Configuration fallbackConfig = MessagesLoader.loadResource(fallback);
            if (fallbackConfig != null) {
                configs.add(fallbackConfig);
            }
        } else {
            System.err.println("No fallback exists for language '" + language + "'!");
        }
        try {
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)new File(directory, language + ".yml"));
            configs.add(new BukkitConfiguration((ConfigurationSection)config));
        }
        catch (Exception ex) {
            System.err.println("Unable load custom language file.");
        }
        messages.setMessages(configs.toArray(new Configuration[0]));
    }

    /*
     * Exception decompiling
     */
    private static Configuration loadResource(URL resource) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

