/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.bukkit;

import com.gufli.kingdomcraft.bukkit.KingdomCraftBukkitPlugin;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandException;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginIdentifiableCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.Plugin;

public class KingdomCraftCommand<T extends CommandExecutor & TabCompleter>
extends Command
implements PluginIdentifiableCommand {
    private final KingdomCraftBukkitPlugin plugin;
    private final T executor;

    public KingdomCraftCommand(KingdomCraftBukkitPlugin plugin, T executor, List<String> aliases) {
        super("kingdomcraft", "Root command for kingdomcraft sub-commands.", "/kingdomcraft", aliases);
        super.setLabel("kingdomcraft");
        this.plugin = plugin;
        this.executor = executor;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        try {
            return this.executor.onCommand(sender, (Command)this, commandLabel, args);
        }
        catch (Throwable ex) {
            throw new CommandException("Unhandled exception executing command '" + commandLabel + "' in plugin " + this.plugin.getDescription().getFullName(), ex);
        }
    }

    public List<String> tabComplete(CommandSender sender, String alias, String[] args) throws IllegalArgumentException {
        List completions;
        try {
            completions = ((TabCompleter)this.executor).onTabComplete(sender, (Command)this, alias, args);
        }
        catch (Throwable ex) {
            StringBuilder message = new StringBuilder();
            message.append("Unhandled exception during tab completion for command '/").append(alias).append(' ');
            for (String arg : args) {
                message.append(arg).append(' ');
            }
            message.deleteCharAt(message.length() - 1).append("' in plugin ").append(this.plugin.getDescription().getFullName());
            throw new CommandException(message.toString(), ex);
        }
        if (completions == null) {
            completions = super.tabComplete(sender, alias, args);
        }
        return completions;
    }
}

