/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.bukkit;

import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.events.PluginReloadEvent;
import com.gufli.kingdomcraft.bukkit.KingdomCraftCommand;
import com.gufli.kingdomcraft.bukkit.MessagesLoader;
import com.gufli.kingdomcraft.bukkit.Metrics;
import com.gufli.kingdomcraft.bukkit.chat.DiscordSRVHandler;
import com.gufli.kingdomcraft.bukkit.command.CommandHandler;
import com.gufli.kingdomcraft.bukkit.config.BukkitConfiguration;
import com.gufli.kingdomcraft.bukkit.entity.BukkitPlayer;
import com.gufli.kingdomcraft.bukkit.gui.InventoryListener;
import com.gufli.kingdomcraft.bukkit.item.BukkitItemSerializer;
import com.gufli.kingdomcraft.bukkit.listeners.AdminJoinListener;
import com.gufli.kingdomcraft.bukkit.listeners.ChatListener;
import com.gufli.kingdomcraft.bukkit.listeners.ConnectionListener;
import com.gufli.kingdomcraft.bukkit.listeners.DeathListener;
import com.gufli.kingdomcraft.bukkit.listeners.DisplayNameListener;
import com.gufli.kingdomcraft.bukkit.listeners.FriendlyFireListener;
import com.gufli.kingdomcraft.bukkit.listeners.JoinQuitListener;
import com.gufli.kingdomcraft.bukkit.listeners.KingdomCreateDeleteListener;
import com.gufli.kingdomcraft.bukkit.listeners.KingdomJoinQuitListener;
import com.gufli.kingdomcraft.bukkit.listeners.MoveListener;
import com.gufli.kingdomcraft.bukkit.listeners.PermissionsListener;
import com.gufli.kingdomcraft.bukkit.listeners.RespawnListener;
import com.gufli.kingdomcraft.bukkit.menu.MenuChatListener;
import com.gufli.kingdomcraft.bukkit.permissions.VaultPermissionHandler;
import com.gufli.kingdomcraft.bukkit.placeholders.PlaceholderReplacer;
import com.gufli.kingdomcraft.bukkit.placeholders.VaultPlaceholderReplacer;
import com.gufli.kingdomcraft.bukkit.scheduler.BukkitScheduler;
import com.gufli.kingdomcraft.common.KingdomCraftImpl;
import com.gufli.kingdomcraft.common.KingdomCraftPlugin;
import com.gufli.kingdomcraft.common.config.Configuration;
import com.gufli.kingdomcraft.common.ebean.StorageContext;
import com.gufli.kingdomcraft.common.scheduler.AbstractScheduler;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandMap;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class KingdomCraftBukkitPlugin
extends JavaPlugin
implements KingdomCraftPlugin {
    private KingdomCraftImpl kdc;
    private DiscordSRVHandler discordSRVHandler;
    private final BukkitScheduler scheduler = new BukkitScheduler((Plugin)this);
    private static final Pattern hexColorPattern = Pattern.compile("<#([A-Fa-f0-9]{6})>");

    public KingdomCraftImpl getKdc() {
        return this.kdc;
    }

    @Override
    public AbstractScheduler getScheduler() {
        return this.scheduler;
    }

    @Override
    public void log(String msg) {
        this.getLogger().info(msg);
    }

    @Override
    public void log(String msg, Level level) {
        this.getLogger().log(level, msg);
    }

    @Override
    public String colorify(String msg) {
        Matcher matcher = hexColorPattern.matcher(msg);
        while (matcher.find()) {
            String rgb = matcher.group(1).toLowerCase();
            StringBuilder result = new StringBuilder();
            result.append("&x");
            for (char s2 : rgb.toCharArray()) {
                result.append("&").append(s2);
            }
            msg = msg.substring(0, matcher.start()) + result + msg.substring(matcher.end());
            matcher = hexColorPattern.matcher(msg);
        }
        msg = StringEscapeUtils.unescapeJava((String)msg);
        return ChatColor.translateAlternateColorCodes((char)'&', (String)msg);
    }

    @Override
    public String decolorify(String msg) {
        return ChatColor.stripColor((String)msg);
    }

    public void onEnable() {
        ConfigurationSection config = this.initConfig("config.yml");
        if (config == null || !config.contains("database")) {
            this.getLogger().warning("Database section not found in config.yml!");
            this.disable();
            return;
        }
        new BukkitItemSerializer();
        ClassLoader originalContextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        StorageContext context = new StorageContext(this);
        ConfigurationSection dbConfig = config.getConfigurationSection("database");
        context.init(dbConfig.getString("url"), dbConfig.getString("driver"), dbConfig.getString("username"), dbConfig.getString("password"));
        if (!context.isInitialized()) {
            this.log("Error occured during database initialization. Shutting down plugin.", Level.SEVERE);
            this.disable();
            return;
        }
        Thread.currentThread().setContextClassLoader(originalContextClassLoader);
        this.kdc = new KingdomCraftImpl(this, context);
        this.load();
        for (Player p : Bukkit.getOnlinePlayers()) {
            this.kdc.onLogin(p.getUniqueId(), p.getName()).accept(new BukkitPlayer(p));
        }
        CommandHandler commandHandler = new CommandHandler(this);
        try {
            Field f = Bukkit.getServer().getClass().getDeclaredField("commandMap");
            f.setAccessible(true);
            CommandMap commandMap = (CommandMap)f.get(Bukkit.getServer());
            commandMap.register("kingdomcraft", new KingdomCraftCommand<CommandHandler>(this, commandHandler, this.kdc.getConfig().getCommandAliases()));
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            this.log("Cannot register default command. Shutting down plugin.", Level.SEVERE);
            this.disable();
            return;
        }
        PluginManager pm = this.getServer().getPluginManager();
        pm.registerEvents((Listener)new FriendlyFireListener(this), (Plugin)this);
        pm.registerEvents((Listener)new JoinQuitListener(this), (Plugin)this);
        pm.registerEvents((Listener)new RespawnListener(this), (Plugin)this);
        pm.registerEvents((Listener)new DeathListener(this), (Plugin)this);
        pm.registerEvents((Listener)new InventoryListener(this), (Plugin)this);
        pm.registerEvents((Listener)new PermissionsListener(this), (Plugin)this);
        pm.registerEvents((Listener)new MoveListener(this), (Plugin)this);
        pm.registerEvents((Listener)new ChatListener(this), (Plugin)this);
        pm.registerEvents((Listener)new ConnectionListener(this), (Plugin)this);
        pm.registerEvents((Listener)new MenuChatListener(this), (Plugin)this);
        new VaultPermissionHandler(this);
        new KingdomJoinQuitListener(this);
        new KingdomCreateDeleteListener(this);
        new PlaceholderReplacer(this);
        new VaultPlaceholderReplacer(this);
        new AdminJoinListener(this);
        new DisplayNameListener(this);
        if (this.getServer().getPluginManager().isPluginEnabled("DiscordSRV")) {
            this.discordSRVHandler = new DiscordSRVHandler(this);
        }
        Metrics metrics = new Metrics((Plugin)this, 10101);
        metrics.addCustomChart(new Metrics.SimplePie("kingdoms", () -> {
            int amount = this.kdc.getKingdoms().size();
            if (amount <= 5) {
                return "0-5";
            }
            if (amount <= 10) {
                return "6-10";
            }
            if (amount <= 15) {
                return "11-15";
            }
            if (amount <= 20) {
                return "16-20";
            }
            if (amount <= 25) {
                return "21-25";
            }
            return "25+";
        }));
        this.getLogger().info("Enabled " + this.getDescription().getFullName());
    }

    public void onDisable() {
        if (this.kdc != null) {
            this.kdc.stop();
        }
        if (this.discordSRVHandler != null) {
            this.discordSRVHandler.disable();
        }
    }

    private void disable() {
        this.getPluginLoader().disablePlugin((Plugin)this);
    }

    public void load() {
        ConfigurationSection config = this.initConfig("config.yml");
        if (config != null && config.contains("settings")) {
            config = config.getConfigurationSection("settings");
            this.kdc.getConfig().load(new BukkitConfiguration(config));
            this.loadMessages(config.getString("language"));
        } else {
            this.log("An error occured, cannot load config.yml", Level.WARNING);
            this.kdc.getChatManager().load(this.getConfigResource("config.yml"));
        }
        ConfigurationSection permissionsConfig = this.initConfig("permissions.yml");
        if (permissionsConfig != null) {
            this.kdc.getPermissionManager().load(new BukkitConfiguration(permissionsConfig));
        } else {
            this.log("An error occured, cannot load permissions.yml", Level.WARNING);
            this.kdc.getChatManager().load(this.getConfigResource("permissions.yml"));
        }
        ConfigurationSection chatConfig = this.initConfig("chat.yml");
        if (chatConfig != null) {
            this.kdc.getChatManager().load(new BukkitConfiguration(chatConfig));
        } else {
            this.log("An error occured, cannot load chat.yml", Level.WARNING);
            this.kdc.getChatManager().load(this.getConfigResource("chat.yml"));
        }
        this.kdc.getOnlinePlayers().stream().filter(p -> !((BukkitPlayer)p).getPlayer().isOnline()).forEach(p -> {
            this.log(p.getName() + " was not correctly removed. Please contact the developer!", Level.WARNING);
            this.kdc.onQuit((PlatformPlayer)p);
        });
        this.kdc.getEventManager().dispatch(new PluginReloadEvent());
    }

    private Configuration getConfigResource(String filename) {
        return new BukkitConfiguration((ConfigurationSection)YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(this.getResource(filename), StandardCharsets.UTF_8)));
    }

    private ConfigurationSection initConfig(String name) {
        File configFile = new File(this.getDataFolder(), name);
        if (!configFile.exists()) {
            this.saveResource(name, true);
        }
        YamlConfiguration config = new YamlConfiguration();
        try {
            config.load(configFile);
        }
        catch (IOException | InvalidConfigurationException e) {
            this.log(e.getClass().getSimpleName() + ": " + e.getMessage(), Level.WARNING);
            return null;
        }
        return config;
    }

    private void loadMessages(String language) {
        File directory = new File(this.getDataFolder(), "languages");
        if (!directory.exists()) {
            directory.mkdirs();
        }
        MessagesLoader.load(this.kdc.getMessages(), this.getClassLoader(), directory, language);
    }
}

