/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.api.gui;

import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.gui.Inventory;
import com.gufli.kingdomcraft.api.gui.InventoryCallback;
import com.gufli.kingdomcraft.api.gui.InventoryClickType;
import com.gufli.kingdomcraft.api.gui.InventoryItem;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractInventory<T, U>
implements Inventory<T, U> {
    protected InventoryCallback<U> callback;
    protected Map<Integer, InventoryItem<U>> items = new HashMap<Integer, InventoryItem<U>>();
    protected T handle;

    public AbstractInventory(T handle, InventoryCallback<U> callback) {
        this.handle = handle;
        this.callback = callback;
    }

    public AbstractInventory(T handle) {
        this(handle, null);
    }

    @Override
    public boolean dispatchClick(PlatformPlayer player, InventoryClickType clickType, int slot) {
        InventoryItem<U> item = this.items.get(slot);
        if (this.callback != null) {
            this.callback.onClick(player, clickType, slot, item);
        }
        if (item != null) {
            return item.dispatchClick(player, clickType);
        }
        return false;
    }

    @Override
    public void dispatchClose(PlatformPlayer player) {
        if (this.callback != null) {
            this.callback.onClose(player);
        }
    }

    @Override
    public void dispatchOpen(PlatformPlayer player) {
        if (this.callback != null) {
            this.callback.onOpen(player);
        }
    }

    @Override
    public T getHandle() {
        return this.handle;
    }

    @Override
    public InventoryItem<U> getItem(int slot) {
        return this.items.get(slot);
    }

    @Override
    public <V extends InventoryItem<U>> void setItem(int slot, V item) {
        this.items.put(slot, item);
    }

    @Override
    public void removeItem(int slot) {
        this.items.remove(slot);
    }

    public Map<Integer, InventoryItem<U>> getItems() {
        return this.items;
    }
}

