/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.api.entity;

import com.gufli.kingdomcraft.api.KingdomCraftProvider;
import com.gufli.kingdomcraft.api.domain.User;
import com.gufli.kingdomcraft.api.entity.PlatformLocation;
import com.gufli.kingdomcraft.api.entity.PlatformSender;
import com.gufli.kingdomcraft.api.gui.Inventory;
import java.util.UUID;

public interface PlatformPlayer
extends PlatformSender {
    public static final String CUSTOM_GUI_KEY = "CUSTOM_GUI";

    public UUID getUniqueId();

    public String getName();

    public void teleport(PlatformLocation var1);

    public PlatformLocation getLocation();

    default public User getUser() {
        return KingdomCraftProvider.get().getUser(this);
    }

    default public Inventory<?, ?> getInventory() {
        return this.has(CUSTOM_GUI_KEY) ? this.get(CUSTOM_GUI_KEY, Inventory.class) : null;
    }

    default public void openInventory(Inventory<?, ?> inventory) {
        this.set(CUSTOM_GUI_KEY, inventory);
    }

    public void closeInventory();

    default public boolean isAdmin() {
        return this.getUser().isAdminModeEnabled();
    }

    default public void setAdmin(boolean admin) {
        this.getUser().setAdminModeEnabled(admin);
    }

    default public boolean isSocialSpyEnabled() {
        return this.getUser().isSocialSpyEnabled();
    }

    default public void setSocialSpyEnabled(boolean socialSpy) {
        this.getUser().setSocialSpyEnabled(socialSpy);
    }

    public void set(String var1, Object var2);

    public boolean has(String var1);

    public void remove(String var1);

    public Object get(String var1);

    public <T> T get(String var1, Class<T> var2);
}

