/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.api.entity;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.regex.Pattern;

public class PlatformLocation {
    String worldName;
    double x;
    double y;
    double z;
    float yaw;
    float pitch;

    public PlatformLocation(String worldName, double x, double y, double z) {
        this.worldName = worldName;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public PlatformLocation(String worldName, double x, double y, double z, float yaw, float pitch) {
        this(worldName, x, y, z);
        this.yaw = yaw;
        this.pitch = pitch;
    }

    public String getWorldName() {
        return this.worldName;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public float getPitch() {
        return this.pitch;
    }

    public float getYaw() {
        return this.yaw;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public void setZ(double z) {
        this.z = z;
    }

    public void setYaw(float yaw) {
        this.yaw = yaw;
    }

    public void setPitch(float pitch) {
        this.pitch = pitch;
    }

    public double distanceTo(PlatformLocation l) {
        if (!this.worldName.equals(l.worldName)) {
            return Double.POSITIVE_INFINITY;
        }
        return Math.sqrt(Math.pow(this.x - l.x, 2.0) + Math.pow(this.y - l.y, 2.0) + Math.pow(this.z - l.z, 2.0));
    }

    public String serialize() {
        DecimalFormat df = new DecimalFormat("#.#", new DecimalFormatSymbols(Locale.ROOT));
        return this.worldName + " , " + df.format(this.x) + " , " + df.format(this.y) + " , " + df.format(this.z) + " , " + df.format(this.yaw) + " , " + df.format(this.pitch);
    }

    public static PlatformLocation deserialize(String str) {
        if (str == null) {
            return null;
        }
        if ((str = str.replace(" ", "")).equals("")) {
            return null;
        }
        String[] parts = str.split(Pattern.quote(","));
        if (parts.length < 4) {
            return null;
        }
        PlatformLocation loc = new PlatformLocation(parts[0], Double.parseDouble(parts[1]), Double.parseDouble(parts[2]), Double.parseDouble(parts[3]));
        if (parts.length >= 5) {
            loc.setYaw(Float.parseFloat(parts[4]));
        }
        if (parts.length == 6) {
            loc.setPitch(Float.parseFloat(parts[5]));
        }
        return loc;
    }
}

