/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.api.editor;

import com.gufli.kingdomcraft.api.editor.EditorAttributeType;
import com.gufli.kingdomcraft.api.editor.EditorAttributeValidator;

public class EditorAttribute {
    private final String key;
    private final String display;
    private final String group;
    private final String helpLink;
    private final EditorAttributeType type;
    private final EditorAttributeValidator validator;

    public static Builder builder(String key, String display) {
        return new Builder(key, display);
    }

    private EditorAttribute(String key, String display, String group, String helpLink, EditorAttributeType type, EditorAttributeValidator validator) {
        this.key = key;
        this.display = display;
        this.group = group;
        this.validator = validator;
        this.type = type;
        this.helpLink = helpLink;
    }

    public String key() {
        return this.key;
    }

    public String display() {
        return this.display;
    }

    public String group() {
        return this.group;
    }

    public String helpLink() {
        return this.helpLink;
    }

    public EditorAttributeType type() {
        return this.type;
    }

    public boolean validate(String value) {
        return this.validator == null || this.validator.validate(value);
    }

    public static class Builder {
        private final String key;
        private final String display;
        private String group;
        private String helpLink;
        private EditorAttributeType type;
        private EditorAttributeValidator validator;

        private Builder(String key, String display) {
            if (key == null) {
                throw new IllegalArgumentException("Key cannot be null.");
            }
            if (display == null) {
                throw new IllegalArgumentException("Display cannot be null.");
            }
            this.key = key;
            this.display = display;
        }

        public Builder withValidator(EditorAttributeValidator validator) {
            this.validator = validator;
            return this;
        }

        public Builder withType(EditorAttributeType type) {
            this.type = type;
            if (type != null && this.validator == null) {
                this.validator = type.validator();
            }
            return this;
        }

        public Builder withGroup(String group) {
            this.group = group;
            return this;
        }

        public Builder withHelpLink(String helpLink) {
            this.helpLink = helpLink;
            return this;
        }

        public EditorAttribute build() {
            return new EditorAttribute(this.key, this.display, this.group, this.helpLink, this.type, this.validator);
        }
    }
}

