/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.api.commands;

import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.entity.PlatformSender;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

public abstract class Command {
    private final List<String> commands = new ArrayList<String>();
    private boolean isPlayerOnly;
    private int expectedArguments = -1;
    private String argumentsHint;
    private Supplier<String> explanationMessage;
    private String[] permissions;

    public Command(String command) {
        this.commands.add(command);
    }

    public Command(String command, int expectedArguments) {
        this(command);
        this.expectedArguments = expectedArguments;
    }

    public Command(String command, int expectedArguments, boolean isPlayerOnly) {
        this(command, expectedArguments);
        this.isPlayerOnly = isPlayerOnly;
    }

    protected void addCommand(String alias) {
        this.commands.add(alias);
    }

    public boolean isPlayerOnly() {
        return this.isPlayerOnly;
    }

    public int getExpectedArguments() {
        return this.expectedArguments;
    }

    public String getArgumentsHint() {
        return this.argumentsHint;
    }

    protected void setArgumentsHint(String argumentsHint) {
        this.argumentsHint = argumentsHint;
    }

    public String getExplanationMessage() {
        if (this.hasExplanationMessage()) {
            return this.explanationMessage.get();
        }
        return null;
    }

    public boolean hasExplanationMessage() {
        return this.explanationMessage != null;
    }

    protected void setExplanationMessage(Supplier<String> supplier) {
        this.explanationMessage = supplier;
    }

    public String[] getPermissions() {
        return this.permissions;
    }

    public void setPermissions(String ... permissions) {
        this.permissions = permissions;
    }

    public List<String> getCommands() {
        return this.commands;
    }

    public abstract void execute(PlatformSender var1, String[] var2);

    public List<String> autocomplete(PlatformPlayer player, String[] args) {
        return null;
    }
}

