/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.api;

import com.gufli.kingdomcraft.api.chat.ChatManager;
import com.gufli.kingdomcraft.api.commands.CommandManager;
import com.gufli.kingdomcraft.api.config.KingdomCraftConfig;
import com.gufli.kingdomcraft.api.domain.Kingdom;
import com.gufli.kingdomcraft.api.domain.Model;
import com.gufli.kingdomcraft.api.domain.Relation;
import com.gufli.kingdomcraft.api.domain.RelationType;
import com.gufli.kingdomcraft.api.domain.User;
import com.gufli.kingdomcraft.api.editor.Editor;
import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.event.EventManager;
import com.gufli.kingdomcraft.api.language.Messages;
import com.gufli.kingdomcraft.api.placeholders.PlaceholderManager;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;

public interface KingdomCraft {
    public KingdomCraftConfig getConfig();

    public Messages getMessages();

    public EventManager getEventManager();

    public CommandManager getCommandManager();

    public ChatManager getChatManager();

    public PlaceholderManager getPlaceholderManager();

    public Editor getEditor();

    public Set<PlatformPlayer> getOnlinePlayers();

    public PlatformPlayer getPlayer(UUID var1);

    public PlatformPlayer getPlayer(User var1);

    public PlatformPlayer getPlayer(String var1);

    public User getUser(PlatformPlayer var1);

    public Set<Kingdom> getKingdoms();

    public Set<Kingdom> getKingdoms(boolean var1);

    public Kingdom getKingdom(String var1);

    public Kingdom getKingdom(long var1);

    public CompletableFuture<Kingdom> createKingdom(String var1);

    public Kingdom getTemplateKingdom();

    public Set<Relation> getRelations(Kingdom var1);

    public void setRelation(Kingdom var1, Kingdom var2, RelationType var3);

    public Relation getRelation(Kingdom var1, Kingdom var2);

    public void addRelationRequest(Kingdom var1, Kingdom var2, RelationType var3);

    public Relation getRelationRequest(Kingdom var1, Kingdom var2);

    public void removeRelationRequest(Kingdom var1, Kingdom var2);

    public Set<User> getOnlineUsers();

    public User getOnlineUser(String var1);

    public User getOnlineUser(UUID var1);

    public CompletableFuture<List<User>> getUsers();

    public CompletableFuture<User> getUser(String var1);

    public CompletableFuture<User> getUser(UUID var1);

    public CompletableFuture<Void> saveAsync(Model ... var1);

    public <T extends Model> CompletableFuture<Void> saveAsync(Collection<T> var1);

    public CompletableFuture<Void> deleteAsync(Model ... var1);

    public <T extends Model> CompletableFuture<Void> deleteAsync(Collection<T> var1);

    public String colorify(String var1);
}

